/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.entity.event;

import eu.binbash.p0tjam.entity.event.Event;
import eu.binbash.p0tjam.gui.cutscene.CS_Lvl;
import eu.binbash.p0tjam.gui.cutscene.CutsceneHandler;
import eu.binbash.p0tjam.lvl.Level;
import eu.binbash.p0tjam.lvl.MapHandler;
import eu.binbash.p0tjam.main.Char;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class TeleportEvent
extends Event {
    private Point targetPoint;
    private String targetMap;
    private String originMap;
    private int triggered;
    private Rectangle triggerRect;
    private String info;

    public TeleportEvent(String originMap, Point originPoint, String targetMap, Point targetPoint, String info) {
        this.originMap = originMap;
        this.targetMap = targetMap;
        this.targetPoint = targetPoint;
        this.triggerRect = new Rectangle(originPoint, new Dimension(70, 70));
        this.triggerRect.translate(-35, -35);
        this.info = info;
    }

    @Override
    public void trigger(Char c) {
        MapHandler.inst.loadMap(Level.lvlForString(this.targetMap));
        c.move(this.targetPoint);
        System.out.println("Teleporting for:" + this.targetPoint);
        CutsceneHandler.inst.addCutScene(new CS_Lvl(Level.lvlForString(this.targetMap)));
    }

    @Override
    public boolean isInRange(Point p) {
        if (this.originMap == MapHandler.inst.getCurrentLvl().toString()) {
            return this.triggerRect.contains(p);
        }
        return false;
    }
}

