/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.entity.npc.brains;

import eu.binbash.p0tjam.entity.npc.brains.Mob_AI;
import eu.binbash.p0tjam.gui.Effects;
import eu.binbash.p0tjam.main.Char;
import eu.binbash.p0tjam.tools.Pathfinding;
import java.awt.Point;
import java.util.Random;

public class Teleport_AI
extends Mob_AI {
    private int minTeleportDistance = 200;
    private int teleportDistance = new Random().nextInt(300) + 150;
    private long lastTeleport = 0L;
    private final int delay = 5000;
    private final int coolOff = new Random().nextInt(1000) + 500;
    private boolean active = false;
    private int phase = 0;
    private Point targetTele;

    public Teleport_AI(Char host) {
        super(host, 700);
    }

    @Override
    public void think() {
        if (this.followTarget != null) {
            int dis = (int)this.followTarget.getCoord().distance(this.host.getCoord());
            if (!this.active && dis < this.sightDistance) {
                if (System.currentTimeMillis() - this.lastTeleport > (long)this.coolOff) {
                    if (dis >= this.minTeleportDistance && System.currentTimeMillis() - this.lastTeleport > 5000L) {
                        this.teleport();
                    } else {
                        this.follow(dis);
                        this.attack(dis);
                    }
                }
            } else if (this.phase == 0) {
                ++this.phase;
                Effects.teleport(this.host.getCoord(), true);
                double dir2 = Pathfinding.getDir(this.host.getCoord(), this.followTarget.getCoord());
                Point offSetPoint = Pathfinding.tracePath(dir2, this.teleportDistance);
                this.targetTele = (Point)this.host.getCoord().clone();
                this.targetTele.translate(offSetPoint.x, offSetPoint.y);
                Effects.teleport(this.targetTele, false);
            } else if (this.phase == 1 && System.currentTimeMillis() - this.lastTeleport > 700L) {
                this.host.move(this.targetTele);
                ++this.phase;
            } else if (this.phase == 2 && System.currentTimeMillis() - this.lastTeleport > 500L) {
                this.active = false;
            }
        }
    }

    private void teleport() {
        this.active = true;
        this.phase = 0;
        this.lastTeleport = System.currentTimeMillis();
    }
}

