/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.entity.obj.weapon;

import eu.binbash.p0tjam.entity.obj.Obj;
import eu.binbash.p0tjam.sfx.SFXHandler;
import java.awt.Image;
import java.awt.Point;

public abstract class Weapon
extends Obj {
    protected String name = "Weapon";
    protected int range = 100;
    protected int damage = 1;
    protected int delay = 1000;
    protected Type type = Type.MELEE;
    protected long lastAction = 0L;
    protected Mod modifier = Mod.NONE;
    protected SFXHandler.SFX sfx;
    protected Image icon;

    public Weapon() {
        super(0L, new Point(0, 0), null);
        this.attack();
    }

    public int getRange() {
        return this.range;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getDelay() {
        return this.delay;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void attack() {
        this.lastAction = System.currentTimeMillis();
    }

    public boolean isAttackReady() {
        return System.currentTimeMillis() - this.lastAction > (long)this.getDelay();
    }

    public abstract Mod getModifier();

    public abstract Image getIcon();

    public abstract int getAmmo();

    public abstract void setAmmo(int var1);

    public SFXHandler.SFX getSfx() {
        return this.sfx;
    }

    public void setSfx(SFXHandler.SFX sfx) {
        this.sfx = sfx;
    }

    public static enum Mod {
        NONE,
        EIS,
        CRIT,
        STROM,
        EXPLOSION;

    }

    public static enum Type {
        MELEE,
        PROJECTILE;

    }
}

