/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.gui;

import eu.binbash.p0tjam.gui.cutscene.CutsceneHandler;
import eu.binbash.p0tjam.handler.BulletHandler;
import eu.binbash.p0tjam.handler.Camera;
import eu.binbash.p0tjam.handler.NPCHandler;
import eu.binbash.p0tjam.handler.ObjectHandler;
import eu.binbash.p0tjam.lvl.MapHandler;
import eu.binbash.p0tjam.main.Player;
import eu.binbash.p0tjam.tools.ResourceHandler;
import eu.binbash.p0tjam.tools.Tools;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class Canvas
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int w = 1024;
    public static final int h = 768;
    public static final Canvas inst = new Canvas();
    public static final Map<Type, String> stats = new HashMap<Type, String>();
    public static final List<Pair> hitPoints = new ArrayList<Pair>();
    private static final Font statsFont = new Font("Monospaced", 1, 20);
    private static final Font hitFont = new Font("Serif", 1, 15);
    private static final Font titleFont = new Font("Monospaced", 1, 40);
    private static final Image rgbBuffer = new BufferedImage(1024, 768, 1);
    private static final Image grayBuffer = new BufferedImage(1024, 768, 10);
    private static final List<Object> del_list = new ArrayList<Object>();
    private ColorMode mode = ColorMode.RGB;
    private Image hudGraphic = ResourceHandler.inst.loadBitmap("/assets/hud.png", false);

    private Canvas() {
        this.setSize(1024, 768);
        this.setLayout((LayoutManager)new MigLayout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        List<Pair> list = hitPoints;
        synchronized (list) {
            for (Pair s : hitPoints) {
                if (s.pass <= 100) continue;
                del_list.add(s);
            }
            for (Object o : del_list) {
                hitPoints.remove(o);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        long l = System.currentTimeMillis();
        Image buffer = this.get2dBuffer();
        Graphics2D g2d = (Graphics2D)buffer.getGraphics();
        if (!CutsceneHandler.inst.isRunning()) {
            MapHandler.inst.drawFirstLayer(g2d);
            ObjectHandler.inst.drawObjs(g2d);
            NPCHandler.inst.drawChars(g2d);
            BulletHandler.inst.drawObjs(g2d);
            MapHandler.inst.drawSecondLayer(g2d);
            this.drawIcons(g2d);
            this.drawHud(g2d);
            this.drawStats(g2d);
        } else {
            CutsceneHandler.inst.drawScene(g2d);
        }
        if (g != null) {
            if (buffer == grayBuffer) {
                g2d.setXORMode(Color.WHITE);
            }
            g.drawImage(buffer, 0, 0, null);
        }
    }

    private void drawHud(Graphics2D g2d) {
        int diff = Player.inst.getHealth() * 212 / 100;
        g2d.setColor(Color.RED);
        g2d.fillRect(0, 212 - (diff - 212) * 2, 51, 415 - (212 - diff) * 2);
        g2d.drawImage(this.hudGraphic, 0, 0, null);
    }

    private void drawIcons(Graphics2D g2d) {
        g2d.setColor(Color.BLACK);
        g2d.fillRect(22, 698, 620, 58);
        Player.inst.inventory.drawSprite(g2d);
    }

    private Image get2dBuffer() {
        return Player.inst.getHealth() > 30 ? rgbBuffer : grayBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHitMsg(String msg, Point coord) {
        List<Pair> list = hitPoints;
        synchronized (list) {
            hitPoints.add(new Pair(msg, (Point)coord.clone(), 1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawStats(Graphics2D g2d) {
        g2d.setFont(hitFont);
        g2d.setColor(Color.RED);
        List<Pair> list = hitPoints;
        synchronized (list) {
            for (Pair s : hitPoints) {
                int x = s.point.x - Camera.inst.getCamera().getXPos() + 512;
                int y = s.point.y - Camera.inst.getCamera().getYPos() + 384;
                g2d.drawString(s.msg, x, y - s.pass);
                s.pass = s.pass + 5;
            }
        }
        int y = 20;
        int y2 = -300;
        for (Map.Entry<Type, String> s : stats.entrySet()) {
            g2d.setFont(statsFont);
            g2d.setColor(Color.RED);
            if (s.getValue() == null) continue;
            switch (s.getKey()) {
                case centerMsg: {
                    Tools.drawCenteredString(g2d, titleFont, s.getValue(), 0, y2, Color.ORANGE);
                    y2 += 50;
                    break;
                }
                case fps: 
                case npcCount: 
                case health: {
                    g2d.drawString(s.getValue(), 900, y);
                    y += 20;
                }
            }
        }
    }

    public void setColorMode(ColorMode colorMode) {
        this.mode = colorMode;
    }

    public static enum ColorMode {
        RGB,
        Gray;

    }

    private class Pair {
        public final String msg;
        public final Point point;
        public Integer pass = 1;

        public Pair(String msg, Point p, Integer i) {
            this.msg = msg;
            this.point = p;
            this.pass = i;
            this.point.x += new Random().nextInt(40);
        }
    }

    public static enum Type {
        centerMsg,
        fps,
        npcCount,
        health;

    }
}

