/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.gui.cutscene;

import eu.binbash.p0tjam.gui.cutscene.CutScene;
import java.awt.Graphics2D;
import java.util.LinkedList;
import java.util.Queue;

public class CutsceneHandler {
    public static final CutsceneHandler inst = new CutsceneHandler();
    private static boolean cutSceneActive = false;
    private static CutScene currentCutScene;
    private static Queue<CutScene> cutsceneList;

    static {
        cutsceneList = new LinkedList<CutScene>(){
            private static final long serialVersionUID = 1L;
        };
    }

    public boolean isRunning() {
        return cutSceneActive;
    }

    public void addCutScene(CutScene cs) {
        cutsceneList.add(cs);
    }

    public boolean hasPending() {
        return cutsceneList.size() > 0 && !cutSceneActive && currentCutScene == null;
    }

    public void startPendingScenes() {
        if (!cutSceneActive && currentCutScene == null && cutsceneList.size() > 0) {
            System.out.println("Stating pending scene");
            currentCutScene = cutsceneList.poll();
            currentCutScene.start();
            cutSceneActive = true;
        }
    }

    private CutsceneHandler() {
    }

    public void drawScene(Graphics2D g2d) {
        if (cutSceneActive && currentCutScene != null) {
            if (currentCutScene.isRunning()) {
                currentCutScene.run(g2d);
            } else {
                cutSceneActive = false;
                currentCutScene = null;
            }
        }
    }
}

