/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.handler;

import eu.binbash.p0tjam.entity.obj.Obj;
import eu.binbash.p0tjam.entity.obj.weapon.ProjectileWeapon;
import eu.binbash.p0tjam.entity.obj.weapon.Weapon;
import eu.binbash.p0tjam.gui.Canvas;
import eu.binbash.p0tjam.gui.Effects;
import eu.binbash.p0tjam.handler.BulletHandler;
import eu.binbash.p0tjam.handler.NPCHandler;
import eu.binbash.p0tjam.handler.ObjectHandler;
import eu.binbash.p0tjam.handler.StatHandler;
import eu.binbash.p0tjam.main.Char;
import eu.binbash.p0tjam.main.Player;
import eu.binbash.p0tjam.sfx.SFXHandler;
import eu.binbash.p0tjam.tools.Pathfinding;
import java.awt.Point;
import java.util.Random;

public class BattleHandler {
    public static final BattleHandler inst = new BattleHandler();

    public void attack(Char attacker, Char victim) {
        int dis = (int)victim.getCoord().distance(attacker.getCoord());
        this.attack(attacker, victim, dis);
    }

    public void attack(Char attacker, Char victim, int dis) {
        if (!attacker.getWeapon().isAttackReady() || dis > attacker.getWeapon().getRange()) {
            return;
        }
        attacker.getWeapon().attack();
        if (attacker.getWeapon().getType() == Weapon.Type.MELEE) {
            int dmg = this.hitTarget(attacker.getWeapon(), victim);
        } else if (attacker.getWeapon().getType() == Weapon.Type.PROJECTILE) {
            ProjectileWeapon pWeapon = (ProjectileWeapon)attacker.getWeapon();
            double dir2 = Pathfinding.getDir(attacker.getCoord(), victim.getCoord());
            if (pWeapon.getAmmo() > 0) {
                pWeapon.setAmmo(-1);
                StatHandler.modStat(StatHandler.Stat.NUM_SHOTS, 1L);
                BulletHandler.inst.addProjectile(dir2, pWeapon.getProjectile(), attacker.getCoord());
            } else {
                System.out.println("KeineMuni!!1");
                Player.inst.equipNextWeapon();
            }
        }
    }

    public int hitTarget(Weapon weapon, Char victim) {
        int dmg = weapon.getDamage();
        switch (weapon.getModifier()) {
            case EIS: {
                victim.modifySpeed(victim.getSpeed() <= 0 ? 0 : -1);
                break;
            }
            case CRIT: {
                if (new Random().nextInt(10) != 5) break;
                Canvas.inst.addHitMsg("CRIT!", victim.getCoord());
                dmg *= 2;
            }
        }
        victim.modifyHealth(dmg * -1);
        Effects.splatter(victim.getCoord());
        SFXHandler.inst.randomPlay(SFXHandler.SFX.Hit, 5);
        if (victim != Player.inst) {
            StatHandler.modStat(StatHandler.Stat.DMG_DEALT, dmg);
            SFXHandler.inst.randomPlay(5, SFXHandler.SFX.Take_That_1, SFXHandler.SFX.Take_That_2, SFXHandler.SFX.Take_That_3, SFXHandler.SFX.Take_That_4, SFXHandler.SFX.Laugh);
        } else {
            StatHandler.modStat(StatHandler.Stat.DMG_TAKEN, dmg);
        }
        Canvas.inst.addHitMsg(String.valueOf(dmg), victim.getCoord());
        if (victim.getHealth() <= 0) {
            Effects.extraSplatter(victim.getCoord());
            SFXHandler.inst.randomPlay(3, SFXHandler.SFX.Death_1, SFXHandler.SFX.Death_2);
            this.handleLoot(victim.getLoot(), victim.getCoord());
            StatHandler.modStat(StatHandler.Stat.KILLS, 1L);
        }
        return dmg;
    }

    private void handleLoot(Obj[] loot, Point point) {
        Obj[] objArray = loot;
        int n = loot.length;
        int n2 = 0;
        while (n2 < n) {
            Obj obj = objArray[n2];
            System.out.println("LOOT:" + obj);
            if (new Random().nextInt(10) % 3 == 0) {
                System.out.println("Dropping loot! @" + point);
                obj.getCoord().setLocation(point);
                ObjectHandler.inst.addObj(obj);
                return;
            }
            ++n2;
        }
    }

    public void attackPoint(Char attacker, Point coord) {
        if (!attacker.getWeapon().isAttackReady()) {
            System.out.println(String.valueOf(attacker.getWeapon().getName()) + ".......Attack not ready!!");
            return;
        }
        System.out.println("on");
        Point targetCoord = new Point(attacker.getCoord().x + (coord.x - 512), attacker.getCoord().y + (coord.y - 384));
        if (attacker.getWeapon().getType() == Weapon.Type.PROJECTILE) {
            ProjectileWeapon pWeapon = (ProjectileWeapon)attacker.getWeapon();
            double dir2 = Pathfinding.getDir(attacker.getCoord(), targetCoord);
            if (pWeapon.getAmmo() > 0) {
                pWeapon.setAmmo(-1);
                if (attacker.getWeapon().getSfx() != null) {
                    SFXHandler.inst.play(attacker.getWeapon().getSfx());
                }
                BulletHandler.inst.addProjectile(dir2, pWeapon.getProjectile(), attacker.getCoord());
            } else {
                System.out.println("KeineMuni!!1");
                Player.inst.equipNextWeapon();
            }
            System.out.println("Verbleibende muni:" + pWeapon.getAmmo());
        } else if (attacker.getWeapon().getType() == Weapon.Type.MELEE) {
            Char target = NPCHandler.inst.getClickedNPC(targetCoord);
            if (target != null) {
                int dis = (int)attacker.getCoord().distance(target.getCoord());
                this.attack(attacker, target, dis);
            } else {
                System.out.println("Cant find target");
            }
            if (attacker.getWeapon().getType() == Weapon.Type.MELEE && attacker.getWeapon().getName() == "Sword") {
                Effects.swordWipe(attacker.getCoord());
                SFXHandler.inst.play(SFXHandler.SFX.SwordWipe);
            }
        }
        attacker.getWeapon().attack();
    }
}

