/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.handler;

import eu.binbash.p0tjam.entity.obj.weapon.Projectile;
import eu.binbash.p0tjam.entity.obj.weapon.Weapon;
import eu.binbash.p0tjam.gui.Effects;
import eu.binbash.p0tjam.handler.BattleHandler;
import eu.binbash.p0tjam.handler.NPCHandler;
import eu.binbash.p0tjam.main.Char;
import eu.binbash.p0tjam.main.Player;
import eu.binbash.p0tjam.sfx.SFXHandler;
import eu.binbash.p0tjam.tools.Pathfinding;
import eu.binbash.p0tjam.tools.Tools;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BulletHandler {
    public static final BulletHandler inst = new BulletHandler();
    private Map<Projectile, Double> pMap = Collections.synchronizedMap(new HashMap());
    private final List<Projectile> del_list = new ArrayList<Projectile>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectile(double dir2, Projectile projectile, Point startCoords) {
        projectile.getCoord().setLocation(startCoords);
        Map<Projectile, Double> map = this.pMap;
        synchronized (map) {
            System.out.println("Adding projectile!!! @" + startCoords);
            this.pMap.put(projectile, dir2);
            System.out.println("MAPSIZE:" + this.pMap.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Map<Projectile, Double> map = this.pMap;
        synchronized (map) {
            if (this.pMap.size() == 0) {
                return;
            }
            for (Map.Entry<Projectile, Double> e : this.pMap.entrySet()) {
                Projectile p = e.getKey();
                if (!Tools.onScreen(p.getCoord())) {
                    System.out.println("Projectile not on Screen @ " + p.getCoord());
                    this.del_list.add(p);
                    continue;
                }
                if (p.getModifier() == Weapon.Mod.EXPLOSION && p.getRange() != -1 && p.getTraveledDist() > p.getRange()) {
                    System.out.println("Traved: " + p.getTraveledDist() + " p.range:" + p.getRange());
                    this.check4Splashhit(p);
                    continue;
                }
                p.setTraveledDist(p.getSpeed());
                Point offsetPoint = Pathfinding.tracePath(e.getValue(), p.getSpeed());
                p.getCoord().translate(offsetPoint.x, offsetPoint.y);
                if (!this.check4Hit(p)) continue;
                if (p.getModifier() == Weapon.Mod.EXPLOSION) {
                    this.check4Splashhit(p);
                }
                this.del_list.add(p);
            }
        }
        this.removeInvalid();
    }

    private boolean check4Hit(Projectile projectile) {
        Char c = NPCHandler.inst.getClickedNPC(projectile.getCoord());
        if (c != null && c != Player.inst) {
            BattleHandler.inst.hitTarget(projectile, c);
            return true;
        }
        return false;
    }

    private boolean check4Hit(Projectile projectile, Point coord) {
        Char c = NPCHandler.inst.getClickedNPC(coord);
        if (c != null && c != Player.inst) {
            BattleHandler.inst.hitTarget(projectile, c);
            return true;
        }
        return false;
    }

    private boolean check4Splashhit(Projectile p) {
        int r = p.getSplashRange() / 2;
        Point[] points = new Point[]{new Point(p.getCoord().x + r, p.getCoord().y + r), new Point(p.getCoord().x - r, p.getCoord().y + r), new Point(p.getCoord().x + r, p.getCoord().y - r), new Point(p.getCoord().x - r, p.getCoord().y - r), new Point(p.getCoord().x, p.getCoord().y)};
        if (p.getModifier() == Weapon.Mod.EXPLOSION) {
            Effects.explode(points[4]);
        }
        int i = 0;
        while (i < 5) {
            System.out.println("SPLASH; mod=" + (Object)((Object)p.getModifier()));
            this.check4Hit(p, points[i]);
            ++i;
        }
        SFXHandler.inst.play(SFXHandler.SFX.Explo);
        this.del_list.add(p);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawObjs(Graphics2D g2d) {
        Map<Projectile, Double> map = this.pMap;
        synchronized (map) {
            for (Projectile p : this.pMap.keySet()) {
                if (!Tools.onScreen(p.getCoord())) continue;
                p.drawSprite(g2d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalid() {
        Map<Projectile, Double> map = this.pMap;
        synchronized (map) {
            for (Projectile p : this.del_list) {
                this.pMap.remove(p);
            }
            this.del_list.clear();
        }
    }
}

