/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.handler;

import eu.binbash.p0tjam.entity.npc.Merchant;
import eu.binbash.p0tjam.entity.npc.NPCList;
import eu.binbash.p0tjam.entity.npc.Zombie;
import eu.binbash.p0tjam.gui.Effects;
import eu.binbash.p0tjam.lvl.Level;
import eu.binbash.p0tjam.lvl.MapHandler;
import eu.binbash.p0tjam.main.Char;
import eu.binbash.p0tjam.main.Player;
import eu.binbash.p0tjam.tools.Tools;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NPCHandler {
    public static final NPCHandler inst = new NPCHandler();
    private static final Map<Level, List<Char>> npcList = NPCList.getNPCMap();

    protected List<Char> getCharList() {
        return npcList.get((Object)MapHandler.inst.getCurrentLvl());
    }

    public void update() {
        this.checkStats();
        this.think();
        this.talk();
        this.checkEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkStats() {
        List<Char> list = this.getCharList();
        synchronized (list) {
            ArrayList<Char> del_C = new ArrayList<Char>();
            for (Char c : this.getCharList()) {
                if (c.getHealth() > 0) continue;
                del_C.add(c);
            }
            for (Char c : del_C) {
                this.getCharList().remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkEvent() {
        List<Char> list = this.getCharList();
        synchronized (list) {
            for (Char c : this.getCharList()) {
                MapHandler.inst.isEvent((c.getXPos() + 32) / 64, (c.getYPos() + 32) / 64);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNPC(Char c) {
        List<Char> list = this.getCharList();
        synchronized (list) {
            this.getCharList().add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void talk() {
        List<Char> list = this.getCharList();
        synchronized (list) {
            for (Char c : this.getCharList()) {
                if (!Tools.onScreen(c.getCoord())) continue;
                c.talk();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void think() {
        List<Char> list = this.getCharList();
        synchronized (list) {
            for (Char c : this.getCharList()) {
                if (!Tools.onScreen(c.getCoord())) continue;
                c.think();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawChars(Graphics2D g2d) {
        List<Char> list = this.getCharList();
        synchronized (list) {
            for (Char c : this.getCharList()) {
                if (!Tools.onScreen(c.getCoord())) continue;
                c.drawSprite(g2d);
            }
        }
        Player.inst.drawSprite(g2d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Char getClickedNPC(Point point) {
        List<Char> list = this.getCharList();
        synchronized (list) {
            Rectangle hitbox = new Rectangle(64, 64);
            for (Char c : this.getCharList()) {
                hitbox.setLocation(c.getCoord());
                if (!Tools.onScreen(c.getCoord()) || !hitbox.contains(point)) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Char> getAllRangedNPC(Point point, int boxLength) {
        ArrayList<Char> chars = new ArrayList<Char>();
        List<Char> list = this.getCharList();
        synchronized (list) {
            Rectangle hitbox = new Rectangle(boxLength, boxLength);
            for (Char c : this.getCharList()) {
                hitbox.setLocation(c.getCoord());
                if (!Tools.onScreen(c.getCoord()) || !hitbox.contains(point)) continue;
                chars.add(c);
            }
        }
        return chars;
    }

    public Char getScreenClickedNPC(Point point) {
        point.setLocation(Player.inst.getCoord().x + (point.x - 512), Player.inst.getCoord().y + (point.y - 384));
        return this.getClickedNPC(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<Char> list = this.getCharList();
        synchronized (list) {
            ArrayList<Char> del_C = new ArrayList<Char>();
            for (Char c : this.getCharList()) {
                if (c instanceof Merchant) continue;
                del_C.add(c);
            }
            for (Char c : del_C) {
                this.getCharList().remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        List<Char> list = this.getCharList();
        synchronized (list) {
            for (Char c : this.getCharList()) {
                if (!(c instanceof Zombie)) continue;
                c.modifyHealth(c.getHealth() * -1);
                Effects.extraSplatter(c.getCoord());
            }
        }
    }
}

