/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.handler;

import eu.binbash.p0tjam.entity.obj.Obj;
import eu.binbash.p0tjam.entity.obj.ObjAmmo;
import eu.binbash.p0tjam.handler.StatHandler;
import eu.binbash.p0tjam.sfx.SFXHandler;
import eu.binbash.p0tjam.tools.Tools;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ObjectHandler {
    public static final ObjectHandler inst = new ObjectHandler();
    private List<Obj> objList = Collections.synchronizedList(new ArrayList());
    private final List<Obj> del_list = new ArrayList<Obj>();

    private ObjectHandler() {
    }

    protected List<Obj> getObjList() {
        return this.objList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObj(Obj c) {
        List<Obj> list = this.getObjList();
        synchronized (list) {
            this.getObjList().add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        long time = System.currentTimeMillis();
        List<Obj> list = this.objList;
        synchronized (list) {
            for (Obj o : this.getObjList()) {
                if (!this.hasDecayed(o, time)) continue;
                this.del_list.add(o);
            }
            for (Obj o : this.del_list) {
                this.objList.remove(o);
            }
            this.del_list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj getObjAt(Point point) {
        List<Obj> list = this.getObjList();
        synchronized (list) {
            Rectangle hitbox = new Rectangle(64, 64);
            for (Obj o : this.getObjList()) {
                if (!(o instanceof ObjAmmo)) continue;
                Point p = new Point(point);
                p.translate(32, 32);
                hitbox.setLocation(o.getCoord());
                if (!Tools.onScreen(o.getCoord()) || !hitbox.contains(p)) continue;
                o.decayNow();
                System.out.println("Picked up: " + o);
                StatHandler.modStat(StatHandler.Stat.OBJ_PICKED, 1L);
                SFXHandler.inst.play(SFXHandler.SFX.Ammo_Joy);
                return o;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawObjs(Graphics2D g2d) {
        List<Obj> list = this.getObjList();
        synchronized (list) {
            for (Obj o : this.getObjList()) {
                if (!Tools.onScreen(o.getCoord())) continue;
                o.drawSprite(g2d);
            }
        }
    }

    private boolean hasDecayed(Obj o, long time) {
        return time > o.getDecay();
    }
}

