/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.handler;

import eu.binbash.p0tjam.gui.Canvas;
import eu.binbash.p0tjam.handler.Animation;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;

public class PlayerAnimation
implements Animation {
    private Image img;
    private long frameMS;
    private long lastUpdate;
    int frameNr = 0;
    private boolean running;

    public PlayerAnimation(Image img, long frameMS) {
        this.img = img;
        this.frameMS = frameMS;
    }

    @Override
    public void drawSprite(Graphics2D g2d) {
        if (!this.running) {
            this.lastUpdate = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastUpdate > this.frameMS) {
            ++this.frameNr;
            if (this.frameNr > 2) {
                this.frameNr = 0;
            }
            this.lastUpdate = System.currentTimeMillis();
        }
        int offsetX = this.frameNr * (this.img.getWidth(null) / 3);
        int wCenter = 512;
        int hCenter = 384;
        int sx1 = offsetX;
        int sx2 = sx1 + this.img.getWidth(null) / 3;
        int sy1 = this.getDir() * (this.img.getHeight(null) / 4);
        int sy2 = sy1 + this.img.getHeight(null) / 4;
        g2d.drawImage(this.img, wCenter, hCenter, wCenter + this.img.getWidth(null) / 3, hCenter + this.img.getHeight(null) / 4, offsetX, sy1, offsetX + this.img.getWidth(null) / 3, sy2, null);
    }

    public int getDir() {
        int wCenter = 512;
        int hCenter = 384;
        Point p = Canvas.inst.getMousePosition();
        if (p == null) {
            return 0;
        }
        double dir2 = Math.atan2(p.y - hCenter, p.x - wCenter) * 180.0 / Math.PI;
        if (dir2 < 0.0) {
            dir2 += 360.0;
        }
        if (dir2 >= 45.0 && dir2 < 135.0) {
            return 0;
        }
        if (dir2 >= 135.0 && dir2 < 225.0) {
            return 1;
        }
        if (dir2 >= 225.0 && dir2 < 315.0) {
            return 3;
        }
        return 2;
    }

    @Override
    public void setRunning(boolean running) {
        this.running = running;
    }

    private static enum dir {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

