/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.handler;

import eu.binbash.p0tjam.gui.Canvas;
import eu.binbash.p0tjam.handler.Animation;
import eu.binbash.p0tjam.handler.Camera;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;

public class SimpelAnimation
implements Animation {
    private Image img;
    private long frameMS;
    private long lastUpdate;
    int frameNr = 0;
    private boolean running;
    private int frames;
    private Point coord;

    public SimpelAnimation(Image img, int frames, long frameMS, Point host) {
        this.img = img;
        this.frames = frames;
        this.frameMS = frameMS;
        this.coord = host;
        this.running = true;
    }

    @Override
    public void drawSprite(Graphics2D g2d) {
        if (!this.running) {
            this.lastUpdate = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this.lastUpdate > this.frameMS) {
            ++this.frameNr;
            if (this.frameNr >= this.frames) {
                this.frameNr = 0;
            }
            this.lastUpdate = System.currentTimeMillis();
        }
        int offsetX = this.frameNr * (this.img.getWidth(null) / this.frames);
        int x = this.coord.x - Camera.inst.getCamera().getXPos() + 512;
        int y = this.coord.y - Camera.inst.getCamera().getYPos() + 384;
        int sx1 = x - offsetX;
        int sy1 = 0;
        int sy2 = this.img.getHeight(null);
        g2d.drawImage(this.img, x - 64, y, x + this.img.getWidth(null) / this.frames - 64, y + this.img.getHeight(null), offsetX, sy1, offsetX + this.img.getWidth(null) / this.frames, sy2, null);
    }

    public int getDir() {
        int wCenter = 512;
        int hCenter = 384;
        Point p = Canvas.inst.getMousePosition();
        if (p == null) {
            return 0;
        }
        double dir2 = Math.atan2(p.y - hCenter, p.x - wCenter) * 180.0 / Math.PI;
        if (dir2 < 0.0) {
            dir2 += 360.0;
        }
        if (dir2 >= 45.0 && dir2 < 135.0) {
            return 0;
        }
        if (dir2 >= 135.0 && dir2 < 225.0) {
            return 1;
        }
        if (dir2 >= 225.0 && dir2 < 315.0) {
            return 3;
        }
        return 2;
    }

    @Override
    public void setRunning(boolean running) {
        this.running = running;
    }
}

