/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.handler;

import eu.binbash.p0tjam.entity.npc.Glob;
import eu.binbash.p0tjam.entity.npc.Schroom;
import eu.binbash.p0tjam.entity.npc.UndeadSwordfighter;
import eu.binbash.p0tjam.entity.npc.Zombie;
import eu.binbash.p0tjam.gui.Canvas;
import eu.binbash.p0tjam.gui.cutscene.CS_EpicWin;
import eu.binbash.p0tjam.handler.NPCHandler;
import eu.binbash.p0tjam.main.Char;
import eu.binbash.p0tjam.main.GameEngine;
import eu.binbash.p0tjam.sfx.SFXHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class WaveHandler {
    private static final long TICKRATE = 5000L;
    public static final WaveHandler inst = new WaveHandler();
    public static int waveNr = 0;
    private static Wave activeWave = null;
    private boolean done = false;
    long lastTone = 0L;
    private Queue<Wave> waveQueue = new LinkedList<Wave>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(new Wave(20000L).addMob(UndeadSwordfighter.class, 2));
            this.add(new Wave().addMob(UndeadSwordfighter.class, 5));
            this.add(new Wave().addMob(Glob.class, 20));
            this.add(new Wave().addMob(Glob.class, 10).addMob(Zombie.class, 2));
            this.add(new Wave().addMob(Schroom.class, 5).addMob(Zombie.class, 10));
            this.add(new Wave().addMob(Zombie.class, 20).addMob(Glob.class, 5));
            this.add(new Wave().addMob(Zombie.class, 15).addMob(Schroom.class, 5).addMob(Glob.class, 3));
            this.add(new Wave().addMob(UndeadSwordfighter.class, 10));
            this.add(new Wave().addMob(Zombie.class, 20));
            this.add(new Wave().addMob(Glob.class, 500));
            this.add(new Wave(100000L).addMob(Glob.class, 1));
        }
    };
    private Timer aiTimer = new Timer();

    private WaveHandler() {
        this.aiTimer.scheduleAtFixedRate((TimerTask)new WaveTimer(), 3000L, 5000L);
    }

    public void update() {
        if (activeWave == null) {
            return;
        }
        long timeUntilWave = (GameEngine.getGameTime() - WaveHandler.activeWave.start - WaveHandler.activeWave.duration) / -1000L;
        if (timeUntilWave < 10L && timeUntilWave > 0L) {
            Canvas.stats.put(Canvas.Type.centerMsg, "Darkness is growing.. " + timeUntilWave);
            if (timeUntilWave != this.lastTone && timeUntilWave < 4L && timeUntilWave > 0L) {
                SFXHandler.inst.play(SFXHandler.SFX.Doom);
                this.lastTone = timeUntilWave;
            }
        }
    }

    private final class Wave {
        public long start;
        public final long duration;
        public Map<Class<? extends Char>, Integer> mobs = new HashMap<Class<? extends Char>, Integer>();

        public Wave(long duration) {
            this.duration = duration;
        }

        public Wave() {
            this.duration = 30000L;
        }

        public Wave addMob(Class<? extends Char> c, int amount) {
            this.mobs.put(c, amount);
            return this;
        }
    }

    private class WaveTimer
    extends TimerTask {
        private WaveTimer() {
        }

        @Override
        public void run() {
            this.displayShow(null);
            if (WaveHandler.this.waveQueue.size() == 0) {
                if (!WaveHandler.this.done) {
                    GameEngine.inst.addCutScene(new CS_EpicWin());
                }
                int mobcount = new Random().nextInt(500);
                WaveHandler.this.waveQueue.add(new Wave(mobcount * 1000).addMob(Zombie.class, mobcount));
                WaveHandler.this.done = true;
                return;
            }
            if (activeWave == null || GameEngine.getGameTime() - activeWave.start > activeWave.duration) {
                activeWave = (Wave)WaveHandler.this.waveQueue.poll();
                activeWave.start = GameEngine.getGameTime();
                this.displayShow("DARKNESS #" + ++waveNr);
                for (Map.Entry<Class<? extends Char>, Integer> wave : activeWave.mobs.entrySet()) {
                    int i = 0;
                    while (i < wave.getValue()) {
                        try {
                            NPCHandler.inst.addNPC(wave.getKey().newInstance());
                        }
                        catch (Exception e) {
                            System.out.println("Exception beim spawnen von wave<" + waveNr + ">");
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
            }
        }

        public void displayShow(String s) {
            Canvas.stats.put(Canvas.Type.centerMsg, s);
        }
    }
}

