/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.lvl;

import eu.binbash.p0tjam.entity.event.Event;
import eu.binbash.p0tjam.handler.Camera;
import eu.binbash.p0tjam.lvl.Level;
import eu.binbash.p0tjam.lvl.Map;
import eu.binbash.p0tjam.lvl.MapCache;
import eu.binbash.p0tjam.main.Player;
import java.awt.Graphics2D;

public class MapHandler {
    public static final MapHandler inst = new MapHandler();
    private Map currentMap;
    private int offsetX;
    private int offsetY;
    private int offsetX2;
    private int offsetY2;
    private Level currentLvl;

    private MapHandler() {
    }

    public void loadMap(Level lvl) {
        System.out.println("Loading Map: <" + (Object)((Object)lvl) + ">");
        if (lvl == this.currentLvl) {
            return;
        }
        long s = System.currentTimeMillis();
        this.currentMap = MapCache.inst.load(lvl);
        this.currentLvl = lvl;
        System.out.println("Map - Loaded base[" + (this.currentMap.mLayer1Bitmap != null) + "] objs[" + (this.currentMap.mLayer2Bitmap != null) + "] took: " + (System.currentTimeMillis() - s));
    }

    public void update() {
        this.offsetX = Camera.inst.getCamera().getXPos() - 512;
        this.offsetY = Camera.inst.getCamera().getYPos() - 384;
        this.offsetX2 = this.offsetX + 1024;
        this.offsetY2 = this.offsetY + 768;
    }

    public void drawFirstLayer(Graphics2D c) {
        c.drawImage(this.currentMap.mLayer1Bitmap, 0, 0, 1024, 768, this.offsetX, this.offsetY, this.offsetX2, this.offsetY2, null);
    }

    public void drawSecondLayer(Graphics2D c) {
        c.drawImage(this.currentMap.mLayer2Bitmap, 0, 0, 1024, 768, this.offsetX, this.offsetY, this.offsetX2, this.offsetY2, null);
    }

    public boolean isWalkable(int x, int y) {
        if (this.currentMap == null) {
            return false;
        }
        try {
            return this.currentMap.objectArea[y][x] == -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isField(int x, int y) {
        return this.currentMap.objectArea[y][x] == LvlAttr.FIELD.id;
    }

    public boolean isEvent(int x, int y) {
        if (this.currentLvl == null) {
            return false;
        }
        for (Event e : this.currentLvl.eventList) {
            if (!e.isInRange(Player.inst.getCoord())) continue;
            e.trigger(Player.inst);
            return true;
        }
        return false;
    }

    public Map getCurrentMap() {
        return this.currentMap;
    }

    public Level getCurrentLvl() {
        return this.currentLvl;
    }

    static enum LvlAttr {
        NON_WALKABLE(2288),
        FIELD(2289),
        TELEPORT(2290);

        public int id;

        private LvlAttr(int id) {
            this.id = id;
        }
    }
}

