/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.main;

import eu.binbash.p0tjam.entity.npc.brains.Brain;
import eu.binbash.p0tjam.entity.obj.Obj;
import eu.binbash.p0tjam.entity.obj.weapon.Bite;
import eu.binbash.p0tjam.entity.obj.weapon.Weapon;
import eu.binbash.p0tjam.gui.Followable;
import eu.binbash.p0tjam.handler.Animation;
import eu.binbash.p0tjam.handler.Camera;
import eu.binbash.p0tjam.lvl.MapHandler;
import eu.binbash.p0tjam.main.CanThink;
import eu.binbash.p0tjam.main.GameEngine;
import eu.binbash.p0tjam.main.Player;
import eu.binbash.p0tjam.sfx.SFXHandler;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.util.Random;

public abstract class Char
implements Followable,
CanThink {
    protected int x = 0;
    protected int y = 0;
    protected int health = 100;
    protected Point coord;
    protected int maxSpeed = 3;
    protected int speed = 3;
    protected Animation animation;
    protected Image img;
    protected String name;
    protected Brain brain;
    protected int xp = 0;
    protected int cooloff = 1000;
    protected long lastAction = 0L;
    protected Weapon weapon;
    protected boolean canSprint = false;
    protected Obj[] loot;
    protected SFXHandler.SFX sfx;
    protected long lastTalk;
    protected long talkDelay = 7000 + new Random().nextInt(14000);

    public Char() {
        this.coord = new Point(this.x, this.y);
        this.weapon = new Bite();
        this.loot = new Obj[0];
    }

    @Override
    public void think() {
        if (this.hasBrain()) {
            this.brain.think();
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Point getCoord() {
        return this.coord;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Override
    public int getXPos() {
        return this.x;
    }

    @Override
    public int getYPos() {
        return this.y;
    }

    @Override
    public void drawSprite(Graphics2D g2d) {
        if (this.animation != null) {
            this.animation.drawSprite(g2d);
        } else if (this.img != null) {
            int x = this.x - Camera.inst.getCamera().getXPos() + 512;
            int y = this.y - Camera.inst.getCamera().getYPos() + 384;
            g2d.drawImage(this.img, x, y, null);
            g2d.setColor(Color.YELLOW);
            if (this.health < 100) {
                g2d.setColor(Color.RED);
            }
            g2d.drawString(String.valueOf(this.health), x, y + this.img.getHeight(null));
        }
    }

    @Override
    public void move(int x, int y) {
        if (this.animation != null) {
            this.animation.setRunning(x != 0 || y != 0);
        }
        this.move(new Point(this.x + x * this.speed, this.y + y * this.speed));
    }

    public String toString() {
        return "<html><b>x</b>=" + this.x + "<br>y</b>=" + this.y + "<br>" + (this.coord != null ? "coord</b>=" + this.coord + "<br>" : "") + "speed</b>=" + this.speed + "<br>" + (this.name != null ? "name</b>=" + this.name : "") + "</html>";
    }

    public boolean hasBrain() {
        return this.brain != null;
    }

    public boolean move(Point newPoint) {
        int x = newPoint.x;
        int y = newPoint.y;
        if (this == Player.inst && !MapHandler.inst.isWalkable((x + 32) / 64, (y + 32) / 64)) {
            return false;
        }
        this.x = x;
        this.y = y;
        this.coord.setLocation(newPoint);
        return true;
    }

    public void modifyHealth(int mod) {
        this.health += mod;
    }

    public int getHealth() {
        return this.health;
    }

    public Obj[] getLoot() {
        return this.loot;
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public void modifySpeed(int i) {
        this.speed += i;
    }

    public boolean isCanSprint() {
        return this.canSprint;
    }

    public void talk() {
        if (this.lastTalk == 0L) {
            this.lastTalk = GameEngine.getGameTime() - 4500L;
        }
        if (this.sfx != null && GameEngine.getGameTime() - this.lastTalk > this.talkDelay) {
            this.lastTalk = GameEngine.getGameTime();
            SFXHandler.inst.play(this.sfx);
        }
    }
}

