/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.main;

import eu.binbash.p0tjam.gui.Canvas;
import eu.binbash.p0tjam.gui.Frame;
import eu.binbash.p0tjam.gui.cutscene.CS_Title;
import eu.binbash.p0tjam.gui.cutscene.CutScene;
import eu.binbash.p0tjam.gui.cutscene.CutsceneHandler;
import eu.binbash.p0tjam.handler.BulletHandler;
import eu.binbash.p0tjam.handler.Camera;
import eu.binbash.p0tjam.handler.KeyHandler;
import eu.binbash.p0tjam.handler.NPCHandler;
import eu.binbash.p0tjam.handler.ObjectHandler;
import eu.binbash.p0tjam.handler.WaveHandler;
import eu.binbash.p0tjam.lvl.Level;
import eu.binbash.p0tjam.lvl.MapHandler;
import eu.binbash.p0tjam.main.Player;
import eu.binbash.p0tjam.sfx.SFXHandler;
import eu.binbash.p0tjam.tools.ResourceHandler;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class GameEngine {
    private Frame frame = Frame.inst;
    private Player player = Player.inst;
    private WaveHandler waveHandler = WaveHandler.inst;
    private Mode mode = Mode.GAME;
    public static final GameEngine inst = new GameEngine();
    private long gameTime = 0L;
    private long startTime;

    private GameEngine() {
        MapHandler.inst.loadMap(Level.Home);
        Camera.inst.setCamera(this.player);
        Canvas.inst.addMouseListener(KeyHandler.inst);
        Canvas.inst.addMouseMotionListener(KeyHandler.inst);
        this.player.move(new Point(678, 454));
        KeyHandler.inst.handleMovementKeys();
        MapHandler.inst.update();
        ObjectHandler.inst.update();
        BulletHandler.inst.update();
        Canvas.inst.update();
        this.addCutScene(new CS_Title());
        this.startTime = System.currentTimeMillis();
        this.startLoop();
    }

    public void addCutScene(CutScene cs) {
        CutsceneHandler.inst.addCutScene(cs);
        this.mode = Mode.CUTSCENE;
    }

    private void setCursor() {
        Cursor c = Toolkit.getDefaultToolkit().createCustomCursor(ResourceHandler.inst.loadBitmap("/assets/cursor.png", false), new Point(20, 20), "p0t");
        this.frame.setCursor(c);
    }

    private void loop() throws Exception {
        long s = System.currentTimeMillis();
        SFXHandler.inst.update();
        if (!CutsceneHandler.inst.isRunning() && CutsceneHandler.inst.hasPending()) {
            this.mode = Mode.CUTSCENE;
        }
        if (this.mode == Mode.GAME) {
            KeyHandler.inst.handleMovementKeys();
            MapHandler.inst.update();
            ObjectHandler.inst.update();
            NPCHandler.inst.update();
            BulletHandler.inst.update();
            WaveHandler.inst.update();
            Canvas.inst.update();
        } else if (this.mode == Mode.CUTSCENE) {
            if (!CutsceneHandler.inst.isRunning() && !CutsceneHandler.inst.hasPending()) {
                this.mode = Mode.GAME;
            } else {
                CutsceneHandler.inst.startPendingScenes();
            }
        }
        Canvas.inst.repaint();
        this.checkHealth();
        Canvas.stats.put(Canvas.Type.fps, "fps:" + (20L - (System.currentTimeMillis() - s)));
        this.syncTime(System.currentTimeMillis() - s);
    }

    private void checkHealth() {
        if (Player.inst.getHeatlth() <= 0) {
            this.setMode(Mode.DEATH);
            Object[] options = new Object[]{"I'll be back", "Respawn me motherfucker!"};
            int a = JOptionPane.showOptionDialog(Canvas.inst, "<html><b>Dead.</b><hr>Raw slabs of meat.<br>You can stop playing now.", "Fucked up and ready to die", 0, 3, new ImageIcon(ResourceHandler.inst.loadBitmap("/assets/portraits/death.jpg", false)), options, options[1]);
            if (a == 0) {
                System.exit(0);
            }
            Player.inst.modifyHealth(Player.inst.getHealth() * -1 + 100);
            NPCHandler.inst.killAll();
            NPCHandler.inst.removeAll();
            SFXHandler.inst.play(SFXHandler.SFX.Respawn);
            this.setMode(Mode.GAME);
        }
    }

    private void syncTime(long tookMS) throws InterruptedException {
        long sleepTime;
        long l = sleepTime = tookMS > 50L ? 0L : 50L - tookMS;
        if (this.mode == Mode.GAME) {
            this.gameTime += tookMS + sleepTime;
        }
        Thread.sleep(tookMS > 50L ? 0L : 50L - tookMS);
    }

    public static long getGameTime() {
        return GameEngine.inst.gameTime;
    }

    private void startLoop() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            GameEngine.this.loop();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
        this.frame.setVisible(true);
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public static enum Mode {
        GAME,
        CUTSCENE,
        DIALOG,
        DEATH;

    }
}

