/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.main;

import eu.binbash.p0tjam.entity.obj.Obj;
import eu.binbash.p0tjam.entity.obj.ObjAmmo;
import eu.binbash.p0tjam.entity.obj.weapon.EisBoltThrower;
import eu.binbash.p0tjam.entity.obj.weapon.FireThrower;
import eu.binbash.p0tjam.entity.obj.weapon.GrenadeLauncher;
import eu.binbash.p0tjam.entity.obj.weapon.MagmaCanon;
import eu.binbash.p0tjam.entity.obj.weapon.Sword;
import eu.binbash.p0tjam.handler.Inventory;
import eu.binbash.p0tjam.handler.ObjectHandler;
import eu.binbash.p0tjam.handler.PlayerAnimation;
import eu.binbash.p0tjam.main.Char;
import eu.binbash.p0tjam.tools.ResourceHandler;
import java.awt.Graphics2D;
import java.awt.Point;

public class Player
extends Char {
    public static final Player inst = new Player();
    public final Inventory inventory = new Inventory();

    public Player() {
        this.name = "The Avatar!";
        this.speed = 6;
        this.animation = new PlayerAnimation(ResourceHandler.inst.loadBitmap("/assets/avatar.png"), 200L);
        this.inventory.addWeapon(new Sword(), new FireThrower(), new EisBoltThrower(), new GrenadeLauncher(), new MagmaCanon());
        this.weapon = this.inventory.equipNextWeapon();
        this.x = 512;
        this.y = 384;
    }

    @Override
    public void drawSprite(Graphics2D g2d) {
        this.animation.drawSprite(g2d);
    }

    public int getHeatlth() {
        return this.health;
    }

    public void equipNextWeapon() {
        this.weapon = this.inventory.equipNextWeapon();
    }

    public void equipNextWeapon(int nr) {
        this.weapon = this.inventory.equipNextWeapon(nr);
    }

    @Override
    public boolean move(Point newPoint) {
        Obj o;
        boolean m = super.move(newPoint);
        if (m && (o = ObjectHandler.inst.getObjAt(newPoint)) != null && o instanceof ObjAmmo) {
            Player.inst.inventory.addAmmo(((ObjAmmo)o).getAmount());
        }
        return m;
    }
}

