/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.sfx;

import java.net.URL;
import java.util.Random;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class SFXHandler {
    public static final SFXHandler inst = new SFXHandler();
    private static Clip bgSfX;

    public void play(final SFX sfx) {
        System.out.println("Playing " + (Object)((Object)sfx) + " s:" + System.currentTimeMillis());
        try {
            Clip clip = SFXHandler.loadClip(sfx.file);
            clip.start();
            clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent evt) {
                    if (evt.getType() == LineEvent.Type.STOP) {
                        System.out.println("Stoping " + (Object)((Object)sfx) + " s:" + System.currentTimeMillis());
                        evt.getLine().close();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
    }

    private static Clip loadClip(URL file) throws Exception {
        Clip c = AudioSystem.getClip();
        System.out.println("Loading:" + file);
        c.open(AudioSystem.getAudioInputStream(file));
        return c;
    }

    public static void setBgSfX(SFX bgSFX) {
        try {
            if (bgSfX != null && (bgSfX.isRunning() || bgSfX.isOpen())) {
                try {
                    bgSfX.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bgSFX != null) {
                bgSfX = SFXHandler.loadClip(bgSFX.file);
                bgSfX.loop(-1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void randomPlay(int rand, SFX ... sfx) {
        if (new Random().nextInt(rand) == rand - 1) {
            this.play(sfx[new Random().nextInt(sfx.length)]);
        }
    }

    public void randomPlay(SFX sfx, int rand) {
        if (new Random().nextInt(rand) == rand - 1) {
            this.play(sfx);
        }
    }

    public static enum SFX {
        Doom("assets/sfx/doom.wav"),
        SwordWipe("assets/sfx/swoosh.wav"),
        Hit("assets/sfx/hit.wav"),
        Explo("assets/sfx/explo.wav"),
        Zombie("assets/sfx/zombie1.wav"),
        Schroom("assets/sfx/schroom.wav"),
        UndeadFighter("assets/sfx/zombie2.wav"),
        Glob("assets/sfx/zombie1.wav"),
        Eis("assets/sfx/eis.wav"),
        Guybrush("assets/sfx/doom.wav"),
        Ammo_Joy("assets/sfx/ammo_joy.wav"),
        Laugh("assets/sfx/laugh.wav"),
        Take_That_1("assets/sfx/takethat1.wav"),
        Take_That_2("assets/sfx/takethat2.wav"),
        Take_That_3("assets/sfx/takethat3.wav"),
        Take_That_4("assets/sfx/takethat4.wav"),
        Take_That_5("assets/sfx/takethat5.wav"),
        Death_1("assets/sfx/death1.wav"),
        Death_2("assets/sfx/death2.wav"),
        Respawn("assets/sfx/respawn.wav"),
        Main("assets/sfx/bongo.wav"),
        TitleScore("assets/sfx/aftermath.wav"),
        Haus("assets/sfx/grusel.wav");

        public URL file;

        private SFX(String f) {
            this.file = ((Object)((Object)this)).getClass().getResource("/" + f);
        }
    }
}

