/*
 * Decompiled with CFR 0.152.
 */
package eu.binbash.p0tjam.tools;

import eu.binbash.p0tjam.tools.MyBase64;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;

public class ResourceHandler {
    public static final ResourceHandler inst = new ResourceHandler();
    public static int mWidthPixels = 1024;
    public static int mHeightPixels = 768;
    public static int scaleFactor = 2;
    private static int mDensityDpi;
    public static final int mTileSize = 32;
    private Image fallBackImg;
    public static final int width = 1024;
    public static final int height = 768;
    public static final int xTileCount = 16;
    public static final int yTileCount = 12;
    private static final Map<String, Image> imgCache;

    static {
        imgCache = new HashMap<String, Image>();
    }

    public void init() {
        long start = System.currentTimeMillis();
        this.loadSprites();
        System.out.println("ResourceHandler - Loading GFX took " + (System.currentTimeMillis() - start));
    }

    private void loadSprites() {
        this.fallBackImg = this.loadBitmap("assets/dog.png");
    }

    public static void setDimensions(int widthPixels, int heightPixels, int densityDpi) {
        mWidthPixels = widthPixels;
        mHeightPixels = heightPixels;
        mDensityDpi = densityDpi;
    }

    public Image loadBitmap(String loc) {
        return this.loadBitmap(loc, true);
    }

    public Image loadBitmap(String loc, boolean scale) {
        Image b;
        if (imgCache.containsKey(loc)) {
            return imgCache.get(loc);
        }
        try {
            long start = System.currentTimeMillis();
            System.out.print("RH - Ladoing id:" + loc);
            URL imageURL = this.getClass().getResource(loc);
            BufferedImage tmpImg = ImageIO.read(imageURL);
            b = scale ? tmpImg.getScaledInstance(tmpImg.getWidth(null) * 2, tmpImg.getHeight(null) * 2, 4) : tmpImg;
            imgCache.put(loc, b);
            System.out.println(" Took:" + (System.currentTimeMillis() - start));
        }
        catch (IOException io) {
            io.printStackTrace();
            b = this.fallBackImg;
        }
        return b;
    }

    public static int[][] loadMap(String map) {
        int[][] mapTiles = new int[100][100];
        System.out.println("RH - Decoding: [" + map + "]");
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(MyBase64.decode(map));
            GZIPInputStream is = new GZIPInputStream(bais);
            long starT = System.currentTimeMillis();
            int y = 0;
            while (y < 100) {
                int x = 0;
                while (x < 100) {
                    int tileId = 0;
                    tileId |= is.read();
                    tileId |= is.read() << 8;
                    tileId |= is.read() << 16;
                    mapTiles[y][x] = (tileId |= is.read() << 24) - 1;
                    System.out.print(String.valueOf(mapTiles[y][x]) + ",");
                    ++x;
                }
                System.out.println("");
                ++y;
            }
            System.out.println("Map - (" + map + ") loading took:" + (System.currentTimeMillis() - starT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mapTiles;
    }
}

