/**
 * @author ssc
 */
function Board(drawHandler) {
	this.currentBoard = tools.create2dArray(Config.y, Config.x);
	this.drawHandler = drawHandler;
	this.cellHandlers = [];
	this.currentGen = 0;
	this.playerCellHandler = null;
}


Board.prototype.addCellHandlers = function(cHandlers) {
	//Der erste ist immer der Spieler CellHandler- merken!
	this.playerCellHandler = cHandlers[0];

	for (var i = 0; i < cHandlers.length; i++) {
		this.cellHandlers.push(cHandlers[i]);
	}
}

Board.prototype.createCellPattern = function(cellPattern, y, x) {
	// var pattern = Cell.getPattern('glider');
	var pattern = cellPattern.build;
	tools.log("PatternyLen:"+pattern.length);
	for (var _y = 0; _y < pattern.length; _y++) {
		for (var _x = 0; _x < pattern[_y].length; _x++) {
			// tools.log("===>"+pattern[_y].charAt(_x)+"<<");
			if(pattern[_y].charAt(_x)=='.')continue;
			var cellY = y+_y;
			var cellX = x+_x;
			// tools.log("_Y:"+_y+" _X:"+_x+" Adding cellX:"+cellX+" Y:"+cellY);
			var cell = cellhandler.createCell(cellY, cellX, 3);
			this.playerCellHandler.addCell(cell, cellY, cellX);
			this.currentBoard[cellY][cellX] = cell;
			// tools.log("Adding cellX:"+cellX+" Y:"+cellY);
		}
	}

	this.draw();
}

Board.prototype.draw = function() {
	this.drawHandler.drawCells(this.currentBoard);
}

Board.prototype.spawn = function(initialPop) {
	for (var i = 0; i < this.cellHandlers.length; i++)
		this.cellHandlers[i].spawn(initialPop, this.currentBoard);
}

Board.prototype.nextGeneration = function() {
	this.currentGen++;
	for (var i = 0; i < this.cellHandlers.length; i++) {
		this.currentBoard = this.cellHandlers[i].tick(this.currentBoard);
	}
	return this.currentGen;
}

Board.prototype.draw = function() {
	this.drawHandler.drawCells(this.currentBoard);
}
