/**
 *
 * @param {int[]} stayAliveRules
 * @param {int[]} birthRules
 * @param {cellType} cellType
 */
function cellhandler(stayAliveRules, birthRules, cellType) {
	this.stayAliveRules = stayAliveRules;
	this.birthRules = birthRules;
	this.cellType = cellType;

	this.cellPositions = tools.create2dArray(Config.y, Config.x);
	this.cells = new Array();
}

/**
 *
 * @param {int} neighborCount
 * @param {Cell} cell
 */
cellhandler.prototype.checkNeighborRules = function(neighborCount, cell) {
	var spawn = false;
	var dead = (!cell);
	if (dead) {
		if (this.containsRule(this.birthRules, neighborCount)) {
			spawn = true;
			// tools.log("br:"+this.birthRules+" nb:"+neighborCount)
		}
	} else if (this.containsRule(this.stayAliveRules, neighborCount)) {
		spawn = true;
	}

	return spawn;
}
/**
 *
 * @param {int[]} rules
 * @param {int} val
 */
cellhandler.prototype.containsRule = function(rules, val) {
	for (var i = 0; i < rules.length; i++) {
		if (rules[i] == val)
			return true;
	}
	return false;
}
/**
 *
 * @param {int} xPos
 * @param {int} yPos
 * @param {cell[][]} world
 */
cellhandler.prototype.countNeighbors = function(xPos, yPos, world, strictType) {
	var yLen = world.length;
	// Einfach die werte aus Config nehmen?
	var xLen = world[0].length;
	var count = 0;

	for (var y = -1; y <= 1; y++) {
		if (y + yPos < 0 || y + yPos >= yLen)
			continue;
		//ioob check
		for (var x = -1; x <= 1; x++) {
			if (x + xPos < 0 || x + xPos >= xLen)
				continue;
			//ioob check

			if (x == 0 && y == 0)
				continue;
			// selfcheck

			// if(strictType) {
				// if(world[y + yPos][x + xPos] && world[y + yPos][x + xPos].cellType != this.cellType) {
			      // tools.log("WCellType: "+world[y + yPos][x + xPos].cellType+" gegen: "+this.cellType);
				  // return 1;
				 // }
			// }else
			if (world[y + yPos][x + xPos]) {
				count++;
				//live neighbor check
				// tools.log("y:"+(y+yPos)+"x:"+(x+xPos)+"is neighbor -->y:"+world[y + yPos][x + xPos].y+" x:"+world[y + yPos][x + xPos].x);
			}
		}
	}
	return count;
}
/**
 *
 * @param {int} y
 * @param {int} x
 */
cellhandler.createCell = function(y, x, celltype) {
	return new Norm(y, x, celltype);
	/*switch(this.cellType) {
	 case Norm:
	 return new Norm(x, y);
	 case Bomb:
	 return new Bomb(x, y);
	 default:
	 window.alert("Unknown CellType:" + cellType);
	 }*/
}
/**
 *
 * @param {Cell} cell
 * @param {int} y
 * @param {int} x
 */
cellhandler.prototype.addCell = function(cell, y, x) {
	// tools.log("Adding cell:"+cell+" cellhandler"+this.cellPositions.length+"y:"+y+"x:"+x+"this:"+this);
	this.cellPositions[y][x] = cell;
	// this.cells.unshift(cell);
	var i = 0;
	for (i; i < this.cells.length; i++) {
		if (!this.cells[i])
			break;
	}
	this.cells[i] = cell;
	// tools.log("__________________");
}
/**
 *
 * @param {Cell} cell
 */
cellhandler.prototype.removeCell = function(cell) {
	if (this.cells.indexOf(cell) >= 0) {
		this.cellPositions[cell.getY()][cell.getX()] = null;
		// tools.log("cSize:"+this.cells.length);
		this.cells[this.cells.indexOf(cell)] = null;
		// tools.log("/cSize:"+this.cells.length);
	} else
		window.alert("Cant find Cell to remove-by-cell:" + cell);
	//throw new RuntimeException("Cant find Cell to remove-by-cell:" + cell);
}
/**
 *
 * @param {int} y
 * @param {int} x
 */
cellhandler.prototype.removeCell = function(y, x) {
	if (this.cellPositions[y][x]) {
		// tools.log("cSize:" + this.cells.length);
		// this.cells.
		this.cells[this.cells.indexOf(this.cellPositions[y][x])] = null;
		// tools.log("/cSize:" + this.cells.length);
		// cells.remove(cellPositions[y][x]);

		this.cellPositions[y][x] = null;
	}
	// else
	// window.alert("Cant find Cell to remove-by-coord: y:" + y + " x:" + x);
	// throw new RuntimeException("Cant find Cell to remove-by-coord: y:" + y + " x:" + x);
}
/**
 *
 * @param {int} initialPop
 * @param {Cell[][]} world
 */
cellhandler.prototype.spawn = function(initialPop, currentBoard) {
	var cellsToSpawn = initialPop;

	do {
		var y = Math.floor(Math.random() * currentBoard.length);
		var x = Math.floor(Math.random() * currentBoard[0].length);

		if (!currentBoard[y][x]) {
			// System.out.println("x: "+x+" y:"+y);
			var cell = cellhandler.createCell(y, x, this.cellType);
			this.addCell(cell, y, x);
			currentBoard[y][x] = cell;

			cellsToSpawn--;
		}
	} while(cellsToSpawn > 0);

	tools.log("Done spawning.");
}
/**
 * @param {Cell[][]} world
 * @return {Cell[][]}
 */
cellhandler.prototype.tick = function(world) {
	var yLen = world.length;
	var xLen = world[0].length;
	var currentOwnWorld = tools.copy2dArray(this.cellPositions);
	//Look at each Cell
	for (var y = 0; y < yLen; y++) {
		for (var x = 0; x < xLen; x++) {

			// Apply the rules
			var neighborCount = this.countNeighbors(x, y, currentOwnWorld, false);
			var enemyCount = this.countNeighbors(x, y, world, true);
			var alive = this.checkNeighborRules(neighborCount, currentOwnWorld[y][x]);
			// tools.log("[" + y + "][" + x + "] haz " + neighborCount);

			// Spawn / kill according to the rules
			// if(enemyCount > 0) {
				// this.removeCell(y, x);
				// world[y][x] = null;
			if (alive && !world[y][x]) {// wenn noch keiner da ist
				var c = new Norm(y, x, this.cellType);
				world[y][x] = c;
				this.addCell(c, y, x);
			} else if (!alive && currentOwnWorld[y][x]) {// wenn er sterben soll und vorher nicht tot war
				this.removeCell(y, x);
				world[y][x] = null;
				//               System.out.println("Dying");
			}
			//Everything else stays!!!!

		}
	}

	return world;
}

cellhandler.prototype.getCellCount = function() {
	var count = 0;
	for (var i = 0; i < this.cells.length; i++) {
		if (this.cells[i])
			count++;
	}
	return count;
}
