function Controls(boardHandler) {
	Controls.boardHandler = boardHandler;
	this.initHandlers();
	this.menuVisible = false;
	Controls.mouseOn = null;
}

Controls.prototype.initHandlers = function() {
	var canvas = document.getElementById('gameCanvas');
	canvas.addEventListener("click", this.clickHandler, false);
	canvas.onmousemove = this.moveHandler;
	canvas.onmouseout = function() {
		Controls.mouseOn = null;
	}
}

Controls.prototype.clickHandler = function(ev) {
	/*if (Controls.boardHandler && Controls.mouseOn) {
	 var x = Math.floor(Controls.mouseOn.x / Config.size);
	 var y = Math.floor(Controls.mouseOn.y / Config.size);
	 Controls.boardHandler.createCellPattern(y,x);
	 }*/

	if (Controls.mouseOn && !drawhandler.showmenu) {
		tools.log("Showing menu! "+Controls.mouseOn.y+" x:"+Controls.mouseOn.x);
		drawhandler.toggleMenu(Controls.mouseOn.y, Controls.mouseOn.x);
	}else if (Controls.mouseOn && drawhandler.showmenu) {
		tools.log("clicking menu! "+Controls.mouseOn.y+" x:"+Controls.mouseOn.x);
		drawhandler.selectMenuItem(Controls.boardHandler, Controls.mouseOn.y, Controls.mouseOn.x);
	}

}

Controls.prototype.moveHandler = function(ev) {
	var can = document.getElementById('gameCanvas');
	// if (!ev) e = event;
	var mouseX = ev.pageX - can.offsetLeft;
	var mouseY = ev.pageY - can.offsetTop;
	Controls.mouseOn = {
		x : mouseX,
		y : mouseY
	};
	// tools.log("x: " + mouseX + " y: " + mouseY);
	/* do something with mouseX/mouseY */
}

