function drawhandler() {
	this.boarder = true;
	this.canvas = document.getElementById('gameCanvas');

	this.backBuffer = document.createElement('canvas');
	this.backBuffer.width = this.canvas.width;
	this.backBuffer.height = this.canvas.height;
	this.backBufferCtx2d = this.backBuffer.getContext('2d');

	this.fogBuffer = document.createElement('canvas');
	this.fogBuffer.width = this.canvas.width;
	this.fogBuffer.height = this.canvas.height;
	this.fogBufferCtx2d = this.fogBuffer.getContext('2d');
	this.fogBufferCtx2d.fillStyle = 'rgb(0,0,0)';
	this.fogBufferCtx2d.fillRect(0, 0, this.canvas.width, this.canvas.height);

	this.gameBuffer = document.createElement('canvas');
	this.gameBuffer.width = this.canvas.width;
	this.gameBuffer.height = this.canvas.height;
	this.gameBufferCtx2d = this.gameBuffer.getContext('2d');

	this.startLoop();
	drawhandler.initImgs();
}

drawhandler.showmenu = false;
drawhandler.menuPosX = 50;
drawhandler.menuPosY = 0;
drawhandler.menuItems = 0;

drawhandler.prototype.startLoop = function() {
	var ref = this;
	setInterval(function() {
		ref.drawGui();
	}, 30);
}

drawhandler.prototype.drawGui = function() {
	var canvasCtx = this.canvas.getContext('2d');

	if (this.boarder && this.backBufferCtx2d) {
		if (canvasCtx && drawhandler.loaded) {
			canvasCtx.clearRect(0, 0, this.canvas.width, this.canvas.height);
			this.backBufferCtx2d.clearRect(0, 0, this.canvas.width, this.canvas.height);

			this.backBufferCtx2d.fillStyle = "rgba(0, 0, 0, 0.9)";
			this.backBufferCtx2d.fillRect(0, 0, this.canvas.width, this.canvas.height);

			this.drawBoarder(this.backBufferCtx2d)

			canvasCtx.drawImage(this.backBuffer, 0, 0);
			canvasCtx.drawImage(this.gameBuffer, 0, 0);

			this.backBufferCtx2d.clearRect(0, 0, this.canvas.width, this.canvas.height);
			// this.drawFogOfWar(this.backBufferCtx2d);
			this.drawMenu(this.backBufferCtx2d);
			this.drawMouse(this.backBufferCtx2d);
			canvasCtx.drawImage(this.backBuffer, 0, 0);
		}
	}

}

drawhandler.getCanvasContext = function() {
	var canvas = document.getElementById('gameCanvas');
	return canvas.getContext('2d');
}

drawhandler.toggleMenu = function(y, x) {
	drawhandler.showmenu = true;
	drawhandler.menuPosX = (x > (Config.x * Config.size) - Config.menuWidth ? (Config.x * Config.size) - Config.menuWidth : x);
	drawhandler.menuPosY = (y > (Config.y * Config.size) - (Config.menuHeight * drawhandler.menuItems) ? (Config.y * Config.size) - (Config.menuHeight * drawhandler.menuItems) : y);
	drawhandler.realPosX = x;
	drawhandler.realPosY = y;
}

drawhandler.initImgs = function() {
	drawhandler.img = new Image();
	drawhandler.img.src = 'img/bg.jpg';
	drawhandler.crossImg = new Image();
	drawhandler.crossImg.src = 'img/crosshair1.png';
	drawhandler.loaded = false;
	drawhandler.img.onload = function() {
		drawhandler.loaded = true;
		tools.log("LOADED");
		// ctx.drawImage(img,0,0);
	}
}
/**
 * Draws the contents of a 2d array to a canvas
 * @param {Cell[][]} world
 */
drawhandler.prototype.drawCells = function(world) {
	if (this.canvas.getContext && drawhandler.loaded) {
		var context = this.gameBufferCtx2d;

		var context2 = document.createElement('canvas');
		context2.width = this.canvas.width;
		context2.height = this.canvas.height;
		var context2Ctx = context2.getContext('2d');

		var fogBuffer4 = document.createElement('canvas');
		fogBuffer4.width = this.canvas.width;
		fogBuffer4.height = this.canvas.height;
		var fogBuffer4Ctx = fogBuffer4.getContext('2d');

		//Blank out!
		this.gameBufferCtx2d.clearRect(0, 0, this.canvas.width, this.canvas.height);
		fogBuffer4Ctx.fillStyle = 'rgba(0,0,0,0.25)';
		fogBuffer4Ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);

		this.fogBufferCtx2d.fillStyle = 'rgb(200,200,0)';
		this.fogBufferCtx2d.save();
		for (var y = 0; y < Config.y; y++) {
			for (var x = 0; x < Config.x; x++) {
				// tools.log("y:"+y+" x:"+x+" haz"+world[y][x]);
				if (world[y][x]) {
					context2Ctx.fillStyle = world[y][x].color;
					context2Ctx.fillRect((x * Config.size), (y * Config.size), Config.size, Config.size);

					//fog-of-war
					fogBuffer4Ctx.fillStyle = 'rgba(0,0,0,0.8)';
					fogBuffer4Ctx.globalCompositeOperation = "destination-out";
					fogBuffer4Ctx.beginPath();
					fogBuffer4Ctx.arc((x * Config.size), (y * Config.size), Math.floor(Math.random() * 15) + 25, 0, Math.PI * 2, false);
					fogBuffer4Ctx.closePath();
					fogBuffer4Ctx.fill();

					this.fogBufferCtx2d.fillStyle = 'rgba(200,200,0,1)';
					this.fogBufferCtx2d.globalCompositeOperation = "destination-out";
					this.fogBufferCtx2d.beginPath();
					this.fogBufferCtx2d.arc((x * Config.size), (y * Config.size), Math.floor(Math.random() * 15) + 25, 0, Math.PI * 2, false);
					this.fogBufferCtx2d.closePath();
					this.fogBufferCtx2d.fill();
				}
			}
		}

		var fogBuffer3 = document.createElement('canvas');
		fogBuffer3.width = this.canvas.width;
		fogBuffer3.height = this.canvas.height;
		var fogBuffer3Ctx = fogBuffer3.getContext('2d');
		fogBuffer3Ctx.drawImage(fogBuffer4, 0, 0);
		fogBuffer3Ctx.drawImage(this.fogBuffer, 0, 0);

		context.drawImage(fogBuffer3, 0, 0);
		context.drawImage(context2, 0, 0);
	}
}

drawhandler.prototype.drawMenu = function(context) {
	// tools.log("Showmenu:"+drawhandler.showmenu);
	if (drawhandler.showmenu && this.boarder && context) {
		var ss = Cell.spaceships;
		var ds = Cell.defence;
		var offX = drawhandler.menuPosX;
		var offY = drawhandler.menuPosY;
		var centerOffset = 0;
		//(Config.menuHeight / 2);

		drawhandler.menuItems = 1 + ss.length + 1 + ds.length;
		context.fillStyle = 'rgb (255,255,255, 0.9)';
		for (var i = 0; i < drawhandler.menuItems; i++) {
			context.fillRect(offX, (i * Config.menuHeight) + offY, Config.menuWidth, Config.menuHeight);
		}
		context.strokeRect(offX, offY, Config.menuWidth, Config.menuHeight * drawhandler.menuItems);

		var pos = 0;

		context.font = Config.menuStyle;
		context.strokeStyle = 'rgb(255,0,0)';
		for (var i = 0; i < ss.length; i++) {
			pos += Config.menuHeight;
			context.strokeText(ss[i].name, offX + 2, pos + centerOffset + offY);
		}

		pos += Config.menuHeight;
		context.strokeStyle = "rgb(0, 255, 0)";
		context.beginPath();
		context.moveTo(offX, pos + centerOffset + offY);
		context.lineTo(Config.menuWidth + offX, pos + centerOffset + offY);
		context.stroke();

		context.strokeStyle = 'rgb(255,0,0)';
		for (var i = 0; i < ds.length; i++) {
			pos += Config.menuHeight;
			context.strokeText(ds[i].name, offX + 2, pos + centerOffset + offY);

		}
		context.drawImage(drawhandler.crossImg, offX - (drawhandler.crossImg.width / 2), offY - (drawhandler.crossImg.height / 2));
	}
}

drawhandler.selectMenuItem = function(boardHandler, y, x) {
	tools.log("Looking for y:" + y + " x:" + x);
	var ss = Cell.spaceships;
	var ds = Cell.defence;
	var pos = (Config.menuHeight / 3) + drawhandler.menuPosY;
	for (var i = 0; i < ss.length; i++) {
		pos += Config.menuHeight;
		if (pos > y && pos < y + Config.menuHeight && x > drawhandler.menuPosX && x < (drawhandler.menuPosX + Config.menuWidth)) {
			boardHandler.createCellPattern(ss[i], Math.floor(drawhandler.realPosY / Config.size), Math.floor(drawhandler.realPosX / Config.size));
		}
	}
	pos += Config.menuHeight;
	for (var i = 0; i < ds.length; i++) {
		pos += Config.menuHeight;
		if (pos > y && pos < y + Config.menuHeight && x > drawhandler.menuPosX && x < (drawhandler.menuPosX + Config.menuWidth)) {
			boardHandler.createCellPattern(ds[i], Math.floor(drawhandler.realPosY / Config.size), Math.floor(drawhandler.realPosX / Config.size));
		}
	}
	drawhandler.showmenu = false;
}

drawhandler.prototype.drawMouse = function(context) {
	if (Controls.mouseOn) {
		context.strokeStyle = "rgb(0, 255, 0)";
		context.beginPath();
		context.lineWidth = 0.7;
		//Horizontal line
		context.moveTo(0, Controls.mouseOn.y);
		context.lineTo(Config.x * Config.size, Controls.mouseOn.y);
		context.stroke();

		//Vertical Line
		context.moveTo(Controls.mouseOn.x, 0);
		context.lineTo(Controls.mouseOn.x, Config.y * Config.size);
		context.stroke();
		context.closePath();
	} else {
		drawhandler.showmenu = false;
	}

}

drawhandler.prototype.drawBoarder = function(context) {
	//Draw background
	if (!Controls.mouseOn) {
		context.drawImage(drawhandler.img, 0, 0);
		return;
	}

	var multiplier = 0.11;
	var bgX = (Math.ceil(Controls.mouseOn.x * multiplier) * -1) + (Math.floor((Config.size * Config.x / 2)) * multiplier);
	var bgY = (Math.ceil(Controls.mouseOn.y * multiplier) * -1) + (Math.floor((Config.size * Config.y / 2)) * multiplier);
	// tools.log("position = " + bgX + "px " + bgY + "px");

	if (drawhandler.loaded) {
		context.drawImage(drawhandler.img, bgX - 36, bgY - 30);
	}

};

